#include <QApplication>
#include "mainwindow.h"

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    QApplication::setApplicationName("LinoSPAD");
    QApplication::setApplicationVersion("17.4.0");

    QCommandLineParser parser;
    parser.setApplicationDescription("LinoSPAD computer software");
    parser.addHelpOption();
    parser.addVersionOption();

    QCommandLineOption settingsFileOption(QStringList() << "s" << "settings", "Read settings from <file>", "file", "settings.txt");
    parser.addOption(settingsFileOption);
    QCommandLineOption resultsFileOption(QStringList() << "r" << "results", "Store results in <file>", "file", "");
    parser.addOption(resultsFileOption);

    parser.process(app);

    QString settingsFile = parser.value(settingsFileOption);
    QString resultsFile = parser.value(resultsFileOption);

    MainWindow win(settingsFile, resultsFile);
    //QIcon icon(":icon/icon.ico");
    //w.setWindowIcon(icon);
    //w.showMaximized();
    win.show();

    return app.exec();
}
